clc,clear
a=load("number.txt");
suma=sum(a)
datanum=sum(suma(2:end))
b=sum(a(:,2:5)');
plot(a(:,1),b','*')
max_neuron_num=max(a(:,1));
min_neuron_num=min(a(:,1));
mid_neuron_num=(max_neuron_num+min_neuron_num)/2;
max_block_num=max(b);
min_block_num=min(b);
mid_block_num=(min_block_num+max_block_num)/2;
hold on

k1=46700/31;
x1=max_block_num/k1;
plot([0,x1],[0,max_block_num]);

k2=11239/51;
y2=max_neuron_num*k2;
plot([0,max_neuron_num],[0,y2]);
% plot([min_neuron_num,max_neuron_num],[mid_block_num,mid_block_num])
% plot([mid_neuron_num,mid_neuron_num],[min_block_num,max_block_num])
box off
hold off;

xticks([])
xticks(0:50:350)
set(gca,'Xticklabel',{'','','','',''});

yticks(0:0.5*10^5:4*10^5);
set(gca,'Yticklabel',{'','','','',''});

quadrant1=[];
quadrant2=[];
quadrant3=[];
b=b';
for i=1:size(a,1)
    if b(i,1)/a(i,1)<k2
        quadrant1=[quadrant1;a(i,2:5)];
    end
    if b(i,1)/a(i,1)>=k2&&b(i,1)/a(i,1)<k1
        quadrant2=[quadrant2;a(i,2:5)];
    end
    if b(i,1)/a(i,1)>=k1
        quadrant3=[quadrant3;a(i,2:5)];
    end
end

quadrant1=quadrant1./sum(quadrant1')';
quadrant2=quadrant2./sum(quadrant2')';
quadrant3=quadrant3./sum(quadrant3')';

tempdata=cell(3,1);
tempdata{1,1}=quadrant1;
tempdata{2,1}=quadrant2;
tempdata{3,1}=quadrant3;


data = cell(3,4);
for c = 1:3
    for l = 1:4
        tmpdata=cell2mat(tempdata(c,1));
        data{c,l} = tmpdata(:,l); 
    end
end

% ===== 拼接成长向量 =====
allData = [];
level   = [];
category = [];

for c = 1:3
    for l = 1:4
        allData  = [allData; data{c,l}(:)];
        level    = [level; l*ones(length(data{c,l}),1)];
        category = [category; c*ones(length(data{c,l}),1)];
    end
end

% ===== 自定义位置 =====
nLevels = 4;
nCats   = 3;
groupSpacing = 1.2;    % 组之间的间隔
catSpacing   = 0.3;  % 组内类别之间的间隔

positions = [];
for l = 1:nLevels
    basePos = (l-1)*groupSpacing;
    for c = 1:nCats
        positions = [positions, basePos + (c-1)*catSpacing];
    end
end

% ===== 画箱线图 =====
figure;
boxplot(allData, {level,category}, 'colors','k', ...
        'positions', positions, 'factorseparator',1)

hold on
h = findobj(gca,'Tag','Box');
colors = lines(3);  % 四类数据颜色
legendHandles = gobjects(3,1);

% 给箱线图上色（注意 boxplot 是从右到左绘制）
for c = 1:nCats
    for l = 1:nLevels
        idx = (l-1)*nCats + c
        patch(get(h(idx),'XData'), get(h(idx),'YData'), colors(c,:), ...
              'FaceAlpha',0.5, 'EdgeColor',colors(c,:));
    end
    legendHandles(c) = patch(NaN,NaN,colors(c,:), 'FaceAlpha',0.5);
end

% ===== 美化坐标轴 =====
ylim([0 1])
yticks(0:0.2:1)
% xlim([-1 7])
yticklabels({'','','','','',''})
xticks(mean(reshape(positions,nCats,[])',2))  % 每组取中间位置
xticklabels({'','','',''})
% xticklabels({'Level 1','Level 2','Level 3','Level 4'})
% xlabel('Level')
% ylabel('Value')
% title('Boxplots: 4 Categories × 4 Levels (Grouped)')
legend(legendHandles, {'III','II','I'}, ...
       'Location','bestoutside')
box off